"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerWatchRoutes = registerWatchRoutes;
var _ack = require("./ack");
var _create = require("./create");
var _delete = require("./delete");
var _execute_graph = require("./execute_graph");
var _execute = require("./execute");
var _get = require("./get");
var _state = require("./state");
/* eslint-disable @kbn/eslint/require-license-header */

function registerWatchRoutes({
  router,
  clusterClient,
  logger
}) {
  (0, _ack.ackWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _create.createWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _delete.deleteWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _execute_graph.executeGraphWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _execute.executeWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _get.getWatchRoute)({
    router,
    clusterClient,
    logger
  });
  (0, _state.stateOfWatchRoute)({
    router,
    clusterClient,
    logger
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfYWNrIiwicmVxdWlyZSIsIl9jcmVhdGUiLCJfZGVsZXRlIiwiX2V4ZWN1dGVfZ3JhcGgiLCJfZXhlY3V0ZSIsIl9nZXQiLCJfc3RhdGUiLCJyZWdpc3RlcldhdGNoUm91dGVzIiwicm91dGVyIiwiY2x1c3RlckNsaWVudCIsImxvZ2dlciIsImFja1dhdGNoUm91dGUiLCJjcmVhdGVXYXRjaFJvdXRlIiwiZGVsZXRlV2F0Y2hSb3V0ZSIsImV4ZWN1dGVHcmFwaFdhdGNoUm91dGUiLCJleGVjdXRlV2F0Y2hSb3V0ZSIsImdldFdhdGNoUm91dGUiLCJzdGF0ZU9mV2F0Y2hSb3V0ZSJdLCJzb3VyY2VzIjpbImluZGV4LmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIEBrYm4vZXNsaW50L3JlcXVpcmUtbGljZW5zZS1oZWFkZXIgKi9cbmltcG9ydCB7IGFja1dhdGNoUm91dGUgfSBmcm9tICcuL2Fjayc7XG5pbXBvcnQgeyBjcmVhdGVXYXRjaFJvdXRlIH0gZnJvbSAnLi9jcmVhdGUnO1xuaW1wb3J0IHsgZGVsZXRlV2F0Y2hSb3V0ZSB9IGZyb20gJy4vZGVsZXRlJztcbmltcG9ydCB7IGV4ZWN1dGVHcmFwaFdhdGNoUm91dGUgfSBmcm9tICcuL2V4ZWN1dGVfZ3JhcGgnO1xuaW1wb3J0IHsgZXhlY3V0ZVdhdGNoUm91dGUgfSBmcm9tICcuL2V4ZWN1dGUnO1xuaW1wb3J0IHsgZ2V0V2F0Y2hSb3V0ZSB9IGZyb20gJy4vZ2V0JztcbmltcG9ydCB7IHN0YXRlT2ZXYXRjaFJvdXRlIH0gZnJvbSAnLi9zdGF0ZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWdpc3RlcldhdGNoUm91dGVzKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSkge1xuICBhY2tXYXRjaFJvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSk7XG4gIGNyZWF0ZVdhdGNoUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KTtcbiAgZGVsZXRlV2F0Y2hSb3V0ZSh7IHJvdXRlciwgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pO1xuICBleGVjdXRlR3JhcGhXYXRjaFJvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSk7XG4gIGV4ZWN1dGVXYXRjaFJvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSk7XG4gIGdldFdhdGNoUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KTtcbiAgc3RhdGVPZldhdGNoUm91dGUoeyByb3V0ZXIsIGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EsSUFBQUEsSUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsT0FBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsT0FBQSxHQUFBRixPQUFBO0FBQ0EsSUFBQUcsY0FBQSxHQUFBSCxPQUFBO0FBQ0EsSUFBQUksUUFBQSxHQUFBSixPQUFBO0FBQ0EsSUFBQUssSUFBQSxHQUFBTCxPQUFBO0FBQ0EsSUFBQU0sTUFBQSxHQUFBTixPQUFBO0FBUEE7O0FBU08sU0FBU08sbUJBQW1CQSxDQUFDO0VBQUVDLE1BQU07RUFBRUMsYUFBYTtFQUFFQztBQUFPLENBQUMsRUFBRTtFQUNyRSxJQUFBQyxrQkFBYSxFQUFDO0lBQUVILE1BQU07SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQztFQUNoRCxJQUFBRSx3QkFBZ0IsRUFBQztJQUFFSixNQUFNO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQUM7RUFDbkQsSUFBQUcsd0JBQWdCLEVBQUM7SUFBRUwsTUFBTTtJQUFFQyxhQUFhO0lBQUVDO0VBQU8sQ0FBQyxDQUFDO0VBQ25ELElBQUFJLHFDQUFzQixFQUFDO0lBQUVOLE1BQU07SUFBRUMsYUFBYTtJQUFFQztFQUFPLENBQUMsQ0FBQztFQUN6RCxJQUFBSywwQkFBaUIsRUFBQztJQUFFUCxNQUFNO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQUM7RUFDcEQsSUFBQU0sa0JBQWEsRUFBQztJQUFFUixNQUFNO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQUM7RUFDaEQsSUFBQU8sd0JBQWlCLEVBQUM7SUFBRVQsTUFBTTtJQUFFQyxhQUFhO0lBQUVDO0VBQU8sQ0FBQyxDQUFDO0FBQ3REIn0=